//
//  QuickSDKCocos_ios.h
//  QuickSDKInterfaceCocos
//
//  Created by 0280106PC0119 on 15/9/8.
//  Copyright (c) 2015年 QuickSDK. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SMPCQuickSDK/SMPCQuickSDK.h>

struct GameRoleInfo;
struct OrderInfo;
@interface QuickSDK_ios : NSObject
{
    NSString *_gameObjectName;
    int initState; //-1未初始化，0初始化失败，1初始化成功
    BOOL bU3dInited; //setListener表明u3d初始化成功
}
+ (QuickSDK_ios *)shareInstance;

- (void)setListener:(NSString *)gameObjectName;
-(void)login;
-(void)logout;
-(void)pay:(SMPCQuickSDKPayOrderInfo *)orderInfo gameRoleInfo:(SMPCQuickSDKGameRoleInfo *)gameRoleInfo;
//-(void)updateRoleInfoWith:(SMPCQuickSDKGameRoleInfo *)gameRoleInfo;//使用
-(void)updateRoleInfoWith:(SMPCQuickSDKGameRoleInfo *)gameRoleInfo isCreate:(BOOL)isCreate;//isCreate表示是否为刚刚创建角色
-(void)enterYunKeFuCenter:(SMPCQuickSDKGameRoleInfo *)gameRoleInfo;
/**
 * 是否开启第三方登录
 */
-(void)openThirdLogin:(BOOL)thirdLogin;
/**
 *  获取当前用户的ID
 *
 *  @return 获取当前用户的ID，如未登录则返回空
 */
- (NSString *)getIdCode;
/**
 *  是否游客账号
 *
 *  @return 获取当前用户的ID，如未登录则返回空
 */
-(BOOL)isGuester;
/**
 * 绑定身份证
 */
-(void)ShowCertification;
/**
 * 游客绑定并绑定身份证
 */
-(void) BindCertification;

-(void)Getlocalized:(NSString *)productIds;
- (int)showRealNameAuth:(int)show;//实名认证;show 非0展示实名认证界面，0查询实名信息
- (int)enterUserCenter;
- (int)enterCustomerCenter;//客服
- (int)enterBBS;//BBS
- (int)showToolBar:(int)place;
- (int)hideToolBar;
- (bool)isFunctionTypeSupported:(int)type;
-(int)pausedGame;
- (NSString *)channelName;          //获取渠道名称
- (NSString *)channelVersion;       //获取渠道版本
- (int)channelType;                 //获取渠道类别 渠道唯一标识
- (NSString *)getParentChannelType;  // 获取父渠道类型
- (NSString *)userId;               //登录后获取UID
- (NSString *)userToken;            //登录后获取userToken
- (NSString *)SDKVersion;      //QuickSDK版本
- (NSString *)getConfigValue:(NSString *)key;  //获取自定义参数
/** 显示隐私弹窗 must:是否必须同意 YES:弹窗仅有同意按钮 NO:同时显示不同意和同意按钮 */
- (void)showGameCustomPrivacyViewMustAgree:(BOOL)must;
-(void)addNotifications;
@end
