//
//  QKN5GameHolder.h
//  H5GameApp
//
//  Created by xingming on 2017/1/13.
//  Copyright © 2017年 xingming. All rights reserved.
//

#define H5ALL_SDK_VERSION @"1.1.0"
#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

#define kMainScreenWidth        (float)([UIScreen mainScreen].bounds.size.width)
#define kMainScreenHeight       (float)([UIScreen mainScreen].bounds.size.height)
#define PROTRAITHEIGHT ([[UIScreen mainScreen] bounds].size.height > [[UIScreen mainScreen] bounds].size.width ? [[UIScreen mainScreen] bounds].size.height : [[UIScreen mainScreen] bounds].size.width)  //屏幕的高度
#define PROTRAITWIDTH ([[UIScreen mainScreen] bounds].size.height > [[UIScreen mainScreen] bounds].size.width ? [[UIScreen mainScreen] bounds].size.width : [[UIScreen mainScreen] bounds].size.height) //屏幕的宽度
#define IS_IPHONE ([UIDevice currentDevice].userInterfaceIdiom == UIUserInterfaceIdiomPhone)
#define IS_IOS_11  ([[[UIDevice currentDevice] systemVersion] floatValue] >= 11.f)
#define DeviceIsLandscape (([UIApplication sharedApplication].statusBarOrientation == UIDeviceOrientationLandscapeLeft ||[UIApplication sharedApplication].statusBarOrientation == UIDeviceOrientationLandscapeRight)?YES:NO)
#define IsIPHONX ((IS_IPHONE && ((int)((PROTRAITHEIGHT/PROTRAITWIDTH)*100) == 216))? YES:NO) /*判断是否是iPhone X*/
#define IsProtraitIPhoneX ((IS_IPHONE && ((int)((kMainScreenHeight/kMainScreenWidth)*100) == 216)) ? YES:NO) /*判断竖屏iPhone X */
#define ISLandscapeIPHONEX ((IsIPHONX && DeviceIsLandscape)?YES:NO)

@protocol QuickH5GameHolderDelegate <NSObject>
- (void)h5gameDidLoaded;
@end

@interface QKN5GameHolder : NSObject

+(instancetype)sharedInstance;
@property (nonatomic,strong) id<QuickH5GameHolderDelegate> delegate;
@property (nonatomic,strong) UIViewController *holderRootViewCtr;
@property (nonatomic,strong) NSString *gameUrlStr;
- (void)reloadGame;
- (void)loadGameFromCfg;

//callback
-(void)callbackEvent:(NSString *)jsonData;//回调web事件

//app事件
- (void)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions;
- (void)applicationWillResignActive:(UIApplication *)application;
- (void)applicationDidEnterBackground:(UIApplication *)application;

- (void)applicationWillEnterForeground:(UIApplication *)application;
- (void)applicationDidBecomeActive:(UIApplication *)application;
- (void)applicationWillTerminate:(UIApplication *)application;
- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken;
- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError *)error;
- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo;
- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window;
- (BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url;
- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(nullable NSString *)sourceApplication annotation:(id)annotation;
- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey, id> *)options;
@end
