//
//  ViewController.m
//  quwanyouxi
//
//  Created by 0280106PC0119 on 2017/2/4.
//  Copyright © 2017年 quicksdk. All rights reserved.
//

#import "ViewController.h"
#import <QKN5GameSDK/QKN5GameSDK.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#import "QWYouXiReachability.h"

@interface ViewController ()
@property (nonatomic, assign) BOOL isReachable;
@property (nonatomic, assign) BOOL timeFinish;
@property(nonatomic,strong)QWYouXiReachability *reachability; //网络监听对象

@end



@implementation ViewController

-(void)dealloc
{
    //停止监听,并移除通知
    [self.reachability stopNotifier];
    [[NSNotificationCenter defaultCenter]removeObserver:self];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    //创建网络监听
    _isReachable = NO;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(networkStateChange:) name:QWYouXikReachabilityChangedNotification object:nil];
    //创建网络监听对象
    self.reachability = [QWYouXiReachability reachabilityForInternetConnection];
    //开始检测
    [self getNetworkType];
    [self.view bringSubviewToFront:self.splashImage];
    NSDictionary *infoDic = [[NSBundle mainBundle] infoDictionary];
    self.baseOrientations = infoDic[@"UISupportedInterfaceOrientations"];
    [self performSelector:@selector(splashHide) withObject:nil afterDelay:3];
}

- (void)h5gameDidLoaded
{
    [self splashHide];
}

-(void)splashHide {
    _timeFinish = YES;
    if (!_isReachable) {
        return;
    }
    NSLog(@"隐藏闪屏");
    [UIView animateWithDuration:0.5 animations:^{
        self.splashImage.alpha = 0;
    } completion:^(BOOL finished) {
        self.splashImage.hidden = YES;
    }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    BOOL landscapeLeft = [self.baseOrientations containsObject:@"UIInterfaceOrientationLandscapeLeft"];
    BOOL landscapeRight = [self.baseOrientations containsObject:@"UIInterfaceOrientationLandscapeRight"];
    BOOL portrait = [self.baseOrientations containsObject:@"UIInterfaceOrientationPortrait"];
    BOOL portraitUpsideDown = [self.baseOrientations containsObject:@"UIInterfaceOrientationPortraitUpsideDown"];
    UIInterfaceOrientationMask mask = 0;
    if (landscapeLeft)
        mask |= UIInterfaceOrientationMaskLandscapeLeft;
    if (landscapeRight)
        mask |= UIInterfaceOrientationMaskLandscapeRight;
    if (portrait)
        mask |= UIInterfaceOrientationMaskPortrait;
    if (portraitUpsideDown)
        mask |= UIInterfaceOrientationMaskPortraitUpsideDown;
    
    return mask;
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation
{
    BOOL landscapeLeft = [self.baseOrientations containsObject:@"UIInterfaceOrientationLandscapeLeft"];
    BOOL landscapeRight = [self.baseOrientations containsObject:@"UIInterfaceOrientationLandscapeRight"];
    //BOOL portrait = [self.baseOrientations containsObject:@"UIInterfaceOrientationPortrait"];
    //BOOL portraitUpsideDown = [self.baseOrientations containsObject:@"UIInterfaceOrientationPortraitUpsideDown"];
    if (landscapeLeft || landscapeRight)
        return UIInterfaceOrientationLandscapeRight;
    else
        return UIInterfaceOrientationPortrait;
}
-(void)networkStateChange:(NSNotification *)note {
//    NSString *  [self getNetworkType];
    QWYouXiReachability *currReach = [note object];
    NSParameterAssert([currReach isKindOfClass:[QWYouXiReachability class]]);
    
    //对连接改变做出响应处理动作
    NetworkStatus status = [currReach currentReachabilityStatus];
    //如果没有连接到网络就弹出提醒实况
    _isReachable = YES;
    if(status == NotReachable) {
        _isReachable = NO;
    } else {
        NSLog(@"QKH5Log:nethaswork");
        _isReachable = YES;
        [self.reachability stopNotifier];
        QKN5GameHolder *holder = [QKN5GameHolder sharedInstance];
        [holder application:[UIApplication sharedApplication] didFinishLaunchingWithOptions:nil];
        [holder setDelegate:self];
        [holder setHolderRootViewCtr:self];
        [holder loadGameFromCfg];
        if (_timeFinish) {
            [self splashHide];
        }
    }
}
/**
 *  判断当前网络类型
 */
- (NSString *)getNetworkType {
    NetworkStatus netStatus = [_reachability currentReachabilityStatus];
    NSString * networkType = @"";
    switch (netStatus) {
        case ReachableViaWiFi: {
            networkType = @"WIFI";
            NSLog(@"QKH5Log:nethaswork");
            _isReachable = YES;
            QKN5GameHolder *holder = [QKN5GameHolder sharedInstance];
            [holder setDelegate:self];
            [holder setHolderRootViewCtr:self];
            [holder loadGameFromCfg];
        }
            break;
        case ReachableViaWWAN: {
            NSLog(@"QKH5Log:nethaswork");
            _isReachable = YES;
            QKN5GameHolder *holder = [QKN5GameHolder sharedInstance];
            [holder setDelegate:self];
            [holder setHolderRootViewCtr:self];
            [holder loadGameFromCfg];
            // 判断蜂窝移动类型
            CTTelephonyNetworkInfo *networkInfo = [[CTTelephonyNetworkInfo alloc] init];
            if (@available(iOS 12.0,*)) {
                NSDictionary<NSString *, NSString *> *infoDic = networkInfo.serviceCurrentRadioAccessTechnology;
                NSLog(@"infoDic = %@", infoDic);
            } else {
                if ([networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyGPRS] ||
                    [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyEdge] ||
                    [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyWCDMA]) {
                    networkType = @"2G";
                } else if ([networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyHSDPA] ||
                           [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyHSUPA] ||
                           [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyCDMA1x] ||
                           [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyCDMAEVDORev0] ||
                           [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyCDMAEVDORevA] ||
                           [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyCDMAEVDORevB] ||
                           [networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyeHRPD]) {
                    networkType = @"3G";
                } else if ([networkInfo.currentRadioAccessTechnology isEqualToString:CTRadioAccessTechnologyLTE]) {
                    networkType = @"4G";
                }
            }
        }
            break;
            
        case NotReachable:{
            networkType = @"当前无网络连接";
            NSLog(@"QKH5Log:nethasnotwork");
            [_reachability startNotifier];
        }
            break;
    }
   
    return networkType;
}
@end
