
def addSystemFrameworks(project, target, frameworks)
    require File.dirname(__FILE__)+'/../lib/xcodeproj'
    
    begin
    proj = Xcodeproj::Project.open(project)
    targetNode = proj.targets.first
    if proj.targets.first.name != target then
        for i in proj.targets
            if i.name == target then
                targetNode = i
                break
            end
        end
    end
    
    totalArrayAll = frameworks.split(',') #dylib and frameworks,去重前的
    totalArray = [] #去重后的
    
    for framework in totalArrayAll
        isExist = false
        frameworkName = File.basename(framework, framework.scan(/\.[^\.]+$/)[0])
        for frameworkExist in targetNode.frameworks_build_phases.file_display_names
            if frameworkExist.scan(/\.[^\.]+$/)[0] == nil then
                next;
            end
            frameworkExistName = File.basename(frameworkExist, frameworkExist.scan(/\.[^\.]+$/)[0])
            if frameworkExistName == frameworkName then
                isExist = true
                break
            end
        end
        if not isExist then
            totalArray << framework
        end
    end
    
    libArray = []
    frameworkArray = []
    for file in totalArray
        suffix = file.scan(/\.[^\.]+$/)[0]
        if suffix == '.dylib' then
#            aLibName = File.basename(file,".dylib")
#            aLibName[0,3] = ''
#            libArray << aLibName
            libArray << file
        elsif suffix == '.tbd' then
#            aLibName = File.basename(file,".tbd")
#            aLibName[0,3] = ''
#            libArray << aLibName
            libArray << file
        elsif suffix == '.framework' then
#            aFname = File.basename(file,".framework")
#            frameworkArray << aFname
            frameworkArray << file
        end
    end
    
    targetNode.add_system_framework(frameworkArray)
    targetNode.add_system_library(libArray)
    puts "target name ========= "
    puts targetNode
    puts "frameworkArray =========== "
    puts frameworkArray
    puts "libArray =========== "
    puts libArray
    proj.save
    
    rescue =>e
        puts e.to_s
        logFileFolder = File.dirname(project)
        f=File.new(File.join(logFileFolder,"addSystemFramework.txt"),"w+")
        f.puts(e.to_s)
        f.close
    end
end

addSystemFrameworks(ARGV[0], ARGV[1], ARGV[2])
