
def addResources(project, target, resources) #只针对修改工程时候调用, 只针对第三方库和资源以及源文件，非系统库
    require File.dirname(__FILE__)+'/../lib/xcodeproj'

    begin
    proj = Xcodeproj::Project.open(project)
    targetNode = proj.targets.first
    if proj.targets.first.name != target then
        for i in proj.targets
            if i.name == target then
                targetNode = i
                break
            end
        end
    end

    group = proj.main_group.find_subpath(File.join('QuickSDK'), true)
    group.set_source_tree('SOURCE_ROOT')
    puts "group is"
    puts group
    
    totalResArray = resources.split(',')
    totalArray = [] #去重后的
    
    for res in totalResArray
        suffix = res.scan(/\.[^\.]+$/)[0]
        if suffix == '.a' || suffix == '.framework' || suffix == '.dylib' || suffix == '.tbd' then
            isExist = false
            resName = File.basename(res, res.scan(/\.[^\.]+$/)[0])
            for resExist in targetNode.frameworks_build_phases.file_display_names
                if resExist.scan(/\.[^\.]+$/)[0] == nil then
                    next;
                end
                resExistName = File.basename(resExist, resExist.scan(/\.[^\.]+$/)[0])
                if resExistName == resName then
                    isExist = true
                    break
                end
            end
            if not isExist then
                totalArray << res
            end
        else
            totalArray << res
        end
    end
    
    refArray = []
    sourceArray = []
    for res in totalArray
        ref = group.new_reference(res, 'SOURCE_ROOT')
        suffix = res.scan(/\.[^\.]+$/)[0]
        if suffix == '.a' || suffix == '.framework' || suffix == '.dylib' || suffix == '.tbd' then
            targetNode.frameworks_build_phase.add_file_reference(ref, true)
        elsif suffix == '.mm' then
            sourceArray << ref
        else
            refArray << ref
        end
    end
    targetNode.add_resources(refArray)
    targetNode.add_file_references(sourceArray)
    
    proj.save
    rescue =>e
        puts e.to_s
        logFileFolder = File.dirname(project)
        f=File.new(File.join(logFileFolder,"addResources.txt"),"w+")
        f.puts(e.to_s)
        f.close
    end
end
    
addResources(ARGV[0], ARGV[1], ARGV[2])
