
def addDynamicFrameworks(project, target, frameworks, frameworkPath)
    puts "项目 target 动态frameworks"
    puts project,target,frameworks
    require File.dirname(__FILE__)+'/../lib/xcodeproj'
    
    begin
    proj = Xcodeproj::Project.open(project)
    targetNode = proj.targets.first
    if proj.targets.first.name != target then
        for i in proj.targets
            if i.name == target then
                targetNode = i
                break
            end
        end
    end
    
    group = proj.main_group.find_subpath(File.join('QuickSDK'), true)
    group.set_source_tree('SOURCE_ROOT')
    frameworkArray = frameworks.split(',')
    
    #添加CopyBuildPhase
    print "add CopyBuildPhase\n"
    if targetNode.copy_files_build_phases.last then
        copyBuildPhase = targetNode.copy_files_build_phases.last
        puts "copyBuildPhase==="
        puts copyBuildPhase
        copyBuildPhase.symbol_dst_subfolder_spec=(:frameworks)
    else
        copyBuildPhase = targetNode.new_copy_files_build_phase('Embed Frameworks')
        copyBuildPhase.symbol_dst_subfolder_spec=(:frameworks)
    end
    print "check if framework exist\n"
    puts "准备添加的库"
    puts frameworkArray
    puts "现有的库"
    puts targetNode.frameworks_build_phases.file_display_names
    puts "现有的库结束"
    for framework in frameworkArray
        # 检测framework是否存在
        frameworkName = File.basename(framework)
        isExist = false
        for frameworkExist in targetNode.frameworks_build_phases.file_display_names
            if frameworkExist == frameworkName then
                isExist = true
                break
            end
        end
        if not isExist then
            file_ref = group.new_reference(framework, 'SOURCE_ROOT')
            targetNode.frameworks_build_phases.add_file_reference(file_ref)
            puts "framework的file_ref"
            puts file_ref
            buildfile = copyBuildPhase.add_file_reference(file_ref, true);
            attr = ['CodeSignOnCopy', 'RemoveHeadersOnCopy'];
            puts "buildfile"
            puts buildfile
            buildfile.settings = {'ATTRIBUTES' => attr}
        end
    end
    print "add framework search path\n"
    #添加framework search path
    frameworkSearchPaths = targetNode.build_configuration_list.get_setting('FRAMEWORK_SEARCH_PATHS')
    print "初始的search path\n"
    puts(frameworkSearchPaths)
#    frameworkPath = '"' << File.expand_path("..",framework) << '"'
    releaseFrameworkSearch = ''
    if frameworkSearchPaths['Release'] then
        releaseFrameworkSearch = frameworkSearchPaths['Release']
    end
    if releaseFrameworkSearch == '' then
        releaseFrameworkSearch = frameworkPath
    else
    #如果没有传入framework路径，添加这个会导致添加一个类似无用路径 "/Users/0280106pc0008/Library/Developer/Xcode/DerivedData/QuickTool-eyasmumbnsivsvbqfkrysromtggj/Build/Products/Debug/QuickTool.app/Contents/Resources/modifyPrj"
        releaseFrameworkSearch << ' ' << frameworkPath
    end
    print "最终的search path\n"
    puts(releaseFrameworkSearch)
    targetNode.build_configuration_list.set_setting('FRAMEWORK_SEARCH_PATHS', releaseFrameworkSearch)

    #添加动态库的runpath search path
    print "add dynamic framework runpath serach path\n"
    runPaths = targetNode.build_configuration_list.get_setting('LD_RUNPATH_SEARCH_PATHS')
    releasePath = ''
    if runPaths['Release'] then
        releasePath = runPaths['Release']
    end
    if releasePath == '' then
        releasePath = '@executable_path/Frameworks'
    else
        releasePath << ' @executable_path/Frameworks'
    end
    
    targetNode.build_configuration_list.set_setting('LD_RUNPATH_SEARCH_PATHS', releasePath)
    print "save project\n"
    proj.save
    print "after save\n"
    rescue =>e
    puts e.to_s
        logFileFolder = File.dirname(project)
        f=File.new(File.join(logFileFolder,"addDynamicFrameworkk.txt"),"w+")
        f.puts(e.to_s)
        f.close
    end
end

addDynamicFrameworks(ARGV[0], ARGV[1], ARGV[2], ARGV[3])
