//
//  PlatformInterface_Unity.m
//  Unity-iPhone
//
//  Created by niko on 14-5-12.
//
//

#import <Foundation/Foundation.h>
#import "QuickSDKInterfaceUnity.h"
#import "QuickSDK_ios.h"
#import <SMPCQuickSDK/SMPCQuickSDK.h>

#if defined(__cplusplus)
extern "C"{
#endif
    
    void quicksdk_nativeSetListener(const char *gameObjectName)
    {
        [[QuickSDK_ios shareInstance] setListener:[NSString stringWithUTF8String:gameObjectName]];
    }
    void quicksdk_nativeLogin()
    {
        [[QuickSDK_ios shareInstance] login];
    }
    void quicksdk_nativeLogout()
    {
        [[QuickSDK_ios shareInstance] logout];
    }
void quicksdk_nativePay(const char *goodsId, const char *goodsName, const char *goodsDesc, const char *quantifier, const char *cpOrderId, const char *callbackUrl, const char *extrasParams, double price, double amount, int count, const char *serverId, const char *serverName, const char *gameRoleName, const char *gameRoleId, const char *gameRoleBalance, const char *vipLevel, const char *gameRoleLevel, const char *partyName, const char *fightPower, const char * profession)
    {
        SMPCQuickSDKPayOrderInfo *orderInfo = [[SMPCQuickSDKPayOrderInfo alloc] init];
        SMPCQuickSDKGameRoleInfo *gameRoleInfo = [[SMPCQuickSDKGameRoleInfo alloc] init];
        orderInfo.goodsID = [NSString stringWithUTF8String:goodsId ? goodsId : ""];
        orderInfo.productName = [NSString stringWithUTF8String:goodsName ? goodsName: ""];
//        orderInfo.productDesc = [NSString stringWithUTF8String:goodsDesc ? goodsDesc: ""]; //停用的属性
//        orderInfo.quantifier = [NSString stringWithUTF8String:quantifier ? quantifier: ""]; //停用的属性
        orderInfo.cpOrderID = [NSString stringWithUTF8String:cpOrderId ? cpOrderId: ""];
//        orderInfo.price = price; //停用的属性
        orderInfo.count = count;
        orderInfo.amount = amount;
        orderInfo.callbackUrl = [NSString stringWithUTF8String:callbackUrl ? callbackUrl: ""];
        orderInfo.extrasParams = [NSString stringWithUTF8String:extrasParams ? extrasParams: ""];
        
        gameRoleInfo.serverId = [NSString stringWithUTF8String:serverId ? serverId: ""];
        gameRoleInfo.serverName = [NSString stringWithUTF8String:serverName ? serverName: ""];
        gameRoleInfo.gameRoleName = [NSString stringWithUTF8String:gameRoleName ? gameRoleName: ""];
        gameRoleInfo.gameRoleID = [NSString stringWithUTF8String:gameRoleId ? gameRoleId: ""];
        gameRoleInfo.gameUserBalance = [NSString stringWithUTF8String:gameRoleBalance ? gameRoleBalance: ""];
        gameRoleInfo.vipLevel = [NSString stringWithUTF8String:vipLevel ? vipLevel: ""];
        gameRoleInfo.gameUserLevel = [NSString stringWithUTF8String:gameRoleLevel ? gameRoleLevel: ""];
        gameRoleInfo.partyName = [NSString stringWithUTF8String:partyName ? partyName: ""];
        gameRoleInfo.fightPower = [NSString stringWithUTF8String:fightPower ? fightPower:""];
        gameRoleInfo.profession = [NSString stringWithUTF8String:profession ? profession:""];
        [[QuickSDK_ios shareInstance] pay:orderInfo gameRoleInfo:gameRoleInfo];
    }
    
    const char* quicksdk_nativeUserId()
    {
        return [[[QuickSDK_ios shareInstance] userId] UTF8String];
    }
    void quicksdk_nativeUpdateRoleInfoWith(const char *serverId, const char *serverName, const char *gameRoleName, const char *gameRoleId, const char *gameRoleBalance, const char *vipLevel, const char *gameRoleLevel, const char *partyName, const char * creatTime, const char *fightPower, const char * profession)
    {
        SMPCQuickSDKGameRoleInfo *gameRoleInfo = [[SMPCQuickSDKGameRoleInfo alloc] init];
        gameRoleInfo.serverId = [NSString stringWithUTF8String:serverId ? serverId: ""];
        gameRoleInfo.serverName = [NSString stringWithUTF8String:serverName ? serverName: ""];
        gameRoleInfo.gameRoleName = [NSString stringWithUTF8String:gameRoleName ? gameRoleName: ""];
        gameRoleInfo.gameRoleID = [NSString stringWithUTF8String:gameRoleId ? gameRoleId: ""];
        gameRoleInfo.gameUserBalance = [NSString stringWithUTF8String:gameRoleBalance ? gameRoleBalance: ""];
        gameRoleInfo.vipLevel = [NSString stringWithUTF8String:vipLevel ? vipLevel: ""];
        gameRoleInfo.gameUserLevel = [NSString stringWithUTF8String:gameRoleLevel ? gameRoleLevel: ""];
        gameRoleInfo.partyName = [NSString stringWithUTF8String:partyName ? partyName: ""];
        gameRoleInfo.creatTime =  [NSString stringWithUTF8String:creatTime ? creatTime: ""];
        gameRoleInfo.fightPower = [NSString stringWithUTF8String:fightPower ? fightPower:""];
        gameRoleInfo.profession = [NSString stringWithUTF8String:profession ? profession:""];
        [[QuickSDK_ios shareInstance] updateRoleInfoWith:gameRoleInfo isCreate:NO];
    }
    void quicksdk_nativeUpdateRoleInfo(const char *serverId, const char *serverName, const char *gameRoleName, const char *gameRoleId, const char *gameRoleBalance, const char *vipLevel, const char *gameRoleLevel, const char *partyName, const char *creatTime, const char *fightPower, const char * profession, BOOL isCreate){
        SMPCQuickSDKGameRoleInfo *gameRoleInfo = [[SMPCQuickSDKGameRoleInfo alloc] init];
        gameRoleInfo.serverId = [NSString stringWithUTF8String:serverId ? serverId: ""];
        gameRoleInfo.serverName = [NSString stringWithUTF8String:serverName ? serverName: ""];
        gameRoleInfo.gameRoleName = [NSString stringWithUTF8String:gameRoleName ? gameRoleName: ""];
        gameRoleInfo.gameRoleID = [NSString stringWithUTF8String:gameRoleId ? gameRoleId: ""];
        gameRoleInfo.gameUserBalance = [NSString stringWithUTF8String:gameRoleBalance ? gameRoleBalance: ""];
        gameRoleInfo.vipLevel = [NSString stringWithUTF8String:vipLevel ? vipLevel: ""];
        gameRoleInfo.gameUserLevel = [NSString stringWithUTF8String:gameRoleLevel ? gameRoleLevel: ""];
        gameRoleInfo.partyName = [NSString stringWithUTF8String:partyName ? partyName: ""];
        gameRoleInfo.creatTime =  [NSString stringWithUTF8String:creatTime ? creatTime: ""];
        gameRoleInfo.fightPower = [NSString stringWithUTF8String:fightPower ? fightPower:""];
        gameRoleInfo.profession = [NSString stringWithUTF8String:profession ? profession:""];
        [[QuickSDK_ios shareInstance] updateRoleInfoWith:gameRoleInfo isCreate:isCreate];
    }
    void quicksdk_nativeEnterYunKeFuCenter(const char *gameRoleId, const char *gameRoleName, const char *serverName, const char *vipLevel){
        SMPCQuickSDKGameRoleInfo *gameRoleInfo = [[SMPCQuickSDKGameRoleInfo alloc] init];
        gameRoleInfo.serverName = [NSString stringWithUTF8String:serverName ? serverName: ""];
        gameRoleInfo.gameRoleName = [NSString stringWithUTF8String:gameRoleName ? gameRoleName: ""];
        gameRoleInfo.gameRoleID = [NSString stringWithUTF8String:gameRoleId ? gameRoleId: ""];
        gameRoleInfo.vipLevel = [NSString stringWithUTF8String:vipLevel ? vipLevel: ""];
        [[QuickSDK_ios shareInstance] enterYunKeFuCenter:gameRoleInfo];
    }
   void quicksdk_getLocalized(const char *productIds)
    {
        [[QuickSDK_ios shareInstance] Getlocalized:[NSString stringWithUTF8String:productIds ? productIds: ""]];
    }
    int quicksdk_nativeRealNameAuth(int show) {
        return [[QuickSDK_ios shareInstance] showRealNameAuth:show];
    }
    int quicksdk_nativeEnterUserCenter()
    {
        return [[QuickSDK_ios shareInstance] enterUserCenter];
    }
    int quicksdk_nativeEnterCustomerCenter()
    {
        return [[QuickSDK_ios shareInstance] enterCustomerCenter];
    }
    int quicksdk_nativeEnterBBS()
    {
        return [[QuickSDK_ios shareInstance] enterBBS];
    }
    int quicksdk_nativeShowToolBar(int place)
    {
        return [[QuickSDK_ios shareInstance] showToolBar:place];
    }
    int quicksdk_nativeHideToolBar()
    {
        return [[QuickSDK_ios shareInstance] hideToolBar];
    }
    int quicksdk_nativePausedGame()
    {
        return [[QuickSDK_ios shareInstance] pausedGame];
    }
    
    bool quicksdk_nativeIsFunctionTypeSupported(int type)
    {
        return [[QuickSDK_ios shareInstance] isFunctionTypeSupported:type];
    }
    const char *quicksdk_nativeChannelName()
    {
        return [[[QuickSDK_ios shareInstance] channelName] UTF8String];
    }
    const char *quicksdk_nativeChannelVersion()
    {
        return [[[QuickSDK_ios shareInstance] channelVersion] UTF8String];
    }
    int quicksdk_nativeChannelType()
    {
        return [[QuickSDK_ios shareInstance] channelType];
    }
    const char* quicksdk_nativeSDKVersion()
    {
        return [[[QuickSDK_ios shareInstance] SDKVersion] UTF8String];
    }
    
    const char* quicksdk_nativeGetConfigValue(const char* key)
    {
        return [[[QuickSDK_ios shareInstance] getConfigValue:[NSString stringWithUTF8String:key ? key : ""]] UTF8String];
    }
    
    
#if defined(__cplusplus)
}
#endif
