/*
 * Decompiled with CFR 0.152.
 */
package com.qk.unity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.quicksdk.BaseCallBack;
import com.quicksdk.Extend;
import com.quicksdk.Payment;
import com.quicksdk.QuickSDK;
import com.quicksdk.Sdk;
import com.quicksdk.User;
import com.quicksdk.entity.GameRoleInfo;
import com.quicksdk.entity.OrderInfo;
import com.quicksdk.entity.ShareInfo;
import com.quicksdk.entity.UserInfo;
import com.quicksdk.notifier.ExitNotifier;
import com.quicksdk.notifier.InitNotifier;
import com.quicksdk.notifier.LoginNotifier;
import com.quicksdk.notifier.LogoutNotifier;
import com.quicksdk.notifier.PayNotifier;
import com.quicksdk.notifier.SwitchAccountNotifier;
import com.quicksdk.utility.AppConfig;
import com.unity3d.player.UnityPlayer;
import com.unity3d.player.UnityPlayerActivity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
public abstract class QuickUnityPlayerproxyActivity
extends UnityPlayerActivity
implements Handler.Callback {
    private static final String TAG = "quicksdk_unity_support";
    private static final int MSG_LOGIN = 101;
    private static final int MSG_LOGOUT = 102;
    private static final int MSG_PAY = 103;
    private static final int MSG_EXIT = 104;
    private static final int MSG_ROLEINFO = 105;
    private static final int MSG_EXTEND_FUNC = 106;
    private static final int MSG_EXTEND_CALLPLUGIN = 107;
    private static final int MSG_EXTEND_FUNC_SHARE = 108;
    private static final int MSG_EXTEND_FUNC_GOODSINFO = 111;
    private static final int MSG_EXTEND_FUNC_GET_DEVICE_ID = 112;
    private static final int MSG_INIT = 120;
    private static final int MSG_EXTEND_FUNC_WiTH_PARAMS = 901;
    private final int REQUEST_RECORD_PERMISSION_SETTING = 999;
    private static final int INIT_SUCCESS = 1;
    private static final int INIT_FAILED = -1;
    private static final int INIT_DEFAULT = 0;
    private QuickUnityInitNotify initNotify = new QuickUnityInitNotify();
    private QuickUnityLoginNotify loginNotify = new QuickUnityLoginNotify();
    private QuickUnitySwitchAccountNotify switchAccountNotify = new QuickUnitySwitchAccountNotify();
    private QuickUnityLogoutNotify logoutNotify = new QuickUnityLogoutNotify();
    private QuickUnityPayNotify payNotify = new QuickUnityPayNotify();
    private QuickUnityExitNotiry exitNotiry = new QuickUnityExitNotiry();
    private String gameObjectName;
    private int initState = 0;
    private String mInitMsg = "";
    Handler mHandler = new Handler((Handler.Callback)this);
    boolean isLancScape = true;
    private Activity mActivity = null;
    private static String goodsInfos = null;
    private boolean isInited = false;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mActivity = this;
        Sdk.getInstance().onCreate((Activity)this);
    }

    protected void onRestart() {
        Sdk.getInstance().onRestart((Activity)this);
        super.onRestart();
    }

    protected void onStart() {
        Sdk.getInstance().onStart((Activity)this);
        super.onStart();
    }

    protected void onResume() {
        Sdk.getInstance().onResume((Activity)this);
        super.onResume();
    }

    protected void onNewIntent(Intent intent) {
        Sdk.getInstance().onNewIntent(intent);
        super.onNewIntent(intent);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Sdk.getInstance().onActivityResult((Activity)this, requestCode, resultCode, data);
    }

    protected void onPause() {
        Sdk.getInstance().onPause((Activity)this);
        super.onPause();
    }

    protected void onStop() {
        Sdk.getInstance().onStop((Activity)this);
        super.onStop();
    }

    protected void onDestroy() {
        Sdk.getInstance().onDestroy((Activity)this);
        super.onDestroy();
    }

    public void doInit() {
        this.isLancScape = this.getResources().getConfiguration().orientation == 2;
        QuickSDK.getInstance().setInitNotifier((InitNotifier)this.initNotify).setLoginNotifier((LoginNotifier)this.loginNotify).setLogoutNotifier((LogoutNotifier)this.logoutNotify).setPayNotifier((PayNotifier)this.payNotify).setExitNotifier((ExitNotifier)this.exitNotiry).setIsLandScape(this.isLancScape).setSwitchAccountNotifier((SwitchAccountNotifier)this.switchAccountNotify);
        Sdk.getInstance().init((Activity)this, this.getProductCode(), this.getProductKey());
    }

    public void requestInit() {
        this.mHandler.sendEmptyMessage(120);
    }

    public void requestLogin() {
        this.mHandler.sendEmptyMessage(101);
    }

    public void requestLogout() {
        this.mHandler.sendEmptyMessage(102);
    }

    public void showPrivace() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Log.d((String)QuickUnityPlayerproxyActivity.TAG, (String)"showPrivace");
                Sdk.getInstance().showPrivace((Activity)QuickUnityPlayerproxyActivity.this, new BaseCallBack(){

                    public void onSuccess(Object ... objects) {
                        Log.d((String)QuickUnityPlayerproxyActivity.TAG, (String)"showPrivace onSuccess: ");
                        QuickUnityPlayerproxyActivity.this.callUnityFunc("onPrivaceAgree", "agree");
                    }

                    public void onFailed(Object ... objects) {
                        Log.d((String)QuickUnityPlayerproxyActivity.TAG, (String)"showPrivace onFailed: ");
                        QuickUnityPlayerproxyActivity.this.callUnityFunc("onPrivaceRefuse", "refuse");
                    }
                });
            }
        });
    }

    public void requestPay(String goodsId, String goodsName, String goodsDesc, String quantifier, String cpOrderId, String callbackUrl, String extraParams, String price, String amount, String count, String serverName, String serverId, String roleName, String roleId, String roleBalance, String vipLevel, String roleLevel, String partyName, String roleCreateTime) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setGoodsName(goodsName);
        orderInfo.setGoodsID(goodsId);
        orderInfo.setGoodsDesc(goodsDesc);
        orderInfo.setQuantifier(quantifier);
        orderInfo.setCpOrderID(cpOrderId);
        orderInfo.setCallbackUrl(callbackUrl);
        orderInfo.setExtrasParams(extraParams);
        orderInfo.setPrice(Double.valueOf(price).doubleValue());
        orderInfo.setAmount(Double.valueOf(amount).doubleValue());
        orderInfo.setCount(Integer.valueOf(count).intValue());
        GameRoleInfo roleInfo = new GameRoleInfo();
        roleInfo.setServerID(serverId);
        roleInfo.setServerName(serverName);
        roleInfo.setGameRoleID(roleId);
        roleInfo.setGameRoleName(roleName);
        roleInfo.setGameUserLevel(roleLevel);
        roleInfo.setGameBalance(roleBalance);
        roleInfo.setVipLevel(vipLevel);
        roleInfo.setPartyName(partyName);
        roleInfo.setRoleCreateTime(roleCreateTime);
        Message msg = this.mHandler.obtainMessage(103);
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        mapObj.put("orderInfo", orderInfo);
        mapObj.put("roleInfo", roleInfo);
        msg.obj = mapObj;
        msg.sendToTarget();
    }

    public void requestExit() {
        this.mHandler.sendEmptyMessage(104);
    }

    public void requestExtendFunc(int funcType) {
        Message msg = this.mHandler.obtainMessage(106);
        msg.arg1 = funcType;
        msg.sendToTarget();
    }

    public void requestCallSDKShare(String title, String content, String imgPath, String imgUrl, String url, String type, String shareTo, String extenal) {
        ShareInfo shareInfo = new ShareInfo();
        shareInfo.setTitle(title);
        shareInfo.setContent(content);
        shareInfo.setImgPath(imgPath);
        shareInfo.setImgUrl(imgUrl);
        shareInfo.setUrl(url);
        shareInfo.setType(type);
        shareInfo.setShareTo(shareTo);
        shareInfo.setExtenal(extenal);
        Message msg = this.mHandler.obtainMessage(108);
        msg.obj = shareInfo;
        msg.sendToTarget();
    }

    public void requestCallCustomPlugin(final String roleId, final String roleName, final String serverName, final String vip) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Extend.getInstance().callPlugin((Activity)QuickUnityPlayerproxyActivity.this, 109, new Object[]{roleId, roleName, serverName, vip});
            }
        });
    }

    public void requestExtendCallPlugin(final int functype, final String[] data) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Log.d((String)QuickUnityPlayerproxyActivity.TAG, (String)("requestExtendCallPlugin: functype == " + functype + "\tdata[0] == " + data[0]));
                Extend.getInstance().callPlugin((Activity)QuickUnityPlayerproxyActivity.this, functype, Arrays.stream(data).toArray());
            }
        });
    }

    public String getUserId() {
        if (User.getInstance().getUserInfo((Activity)this) != null) {
            Log.e((String)TAG, (String)("userId->" + User.getInstance().getUserInfo((Activity)this).getUID()));
            return User.getInstance().getUserInfo((Activity)this).getUID();
        }
        Log.e((String)TAG, (String)"user is null");
        return null;
    }

    public String getDeviceID() {
        return Extend.getInstance().getDeviceID(this.mActivity);
    }

    public void requestUpdateRole(String serverId, String serverName, String roleName, String roleId, String roleBalance, String vipLevel, String roleLevel, String partyName, String roleCreateTime, String roleGender, String rolePower, String partId, String professionId, String profession, String partyRoleId, String partyRoleName, String friendlist, String isCreate) {
        GameRoleInfo roleInfo = new GameRoleInfo();
        roleInfo.setServerID(serverId);
        roleInfo.setServerName(serverName);
        roleInfo.setGameBalance(roleBalance);
        roleInfo.setGameRoleID(roleId);
        roleInfo.setGameRoleName(roleName);
        roleInfo.setVipLevel(vipLevel);
        roleInfo.setGameUserLevel(roleLevel);
        roleInfo.setPartyName(partyName);
        roleInfo.setRoleCreateTime(roleCreateTime);
        roleInfo.setGameRoleGender(roleGender);
        roleInfo.setGameRolePower(rolePower);
        roleInfo.setPartyId(partId);
        roleInfo.setProfessionId(professionId);
        roleInfo.setProfession(profession);
        roleInfo.setPartyId(partyRoleId);
        roleInfo.setPartyRoleName(partyRoleName);
        roleInfo.setFriendlist(friendlist);
        boolean isCreateRole = false;
        if (TextUtils.isEmpty((CharSequence)isCreate) || "false".equalsIgnoreCase(isCreate)) {
            isCreateRole = false;
        } else if ("true".equalsIgnoreCase(isCreate)) {
            isCreateRole = true;
        }
        Message msg = this.mHandler.obtainMessage(105);
        msg.arg1 = isCreateRole ? 1 : 0;
        msg.obj = roleInfo;
        msg.sendToTarget();
    }

    public String callFunc(int funcType) {
        Log.d((String)TAG, (String)("is called:FuncType: " + funcType + ",isFuncSupport: " + this.isFuncSupport(funcType)));
        if (this.isFuncSupport(funcType)) {
            String resultData = Extend.getInstance().callFunction((Activity)this, funcType);
            Log.d((String)TAG, (String)("callFunc: resultcode == " + resultData));
            return resultData;
        }
        return "0";
    }

    public String callFuncWithResult(int funcType) {
        if (this.isFuncSupport(funcType)) {
            String resultCode = Extend.getInstance().callFunction((Activity)this, funcType);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("FunctionType", funcType);
                jsonObject.put("msg", (Object)resultCode);
                this.callUnityFunc("onSuccess", jsonObject.toString());
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
            return resultCode;
        }
        return "0";
    }

    public int callFunc(int funcType, String s) {
        Log.d((String)TAG, (String)("is called:" + s));
        if (this.isFuncSupport(funcType)) {
            Log.d((String)TAG, (String)("is isFuncSupport:" + this.isFuncSupport(funcType)));
            Message msg = this.mHandler.obtainMessage(111);
            msg.arg1 = funcType;
            msg.obj = s;
            msg.sendToTarget();
            return 1;
        }
        return 0;
    }

    public int callFunctionWithParams(int funcType, String[] params) {
        Log.d((String)TAG, (String)("callFunctionWithParams : functype == " + funcType + "\t params == " + params));
        if (this.isFuncSupport(funcType)) {
            Log.d((String)TAG, (String)("is isFuncSupport:" + this.isFuncSupport(funcType)));
            Message msg = this.mHandler.obtainMessage(901);
            msg.arg1 = funcType;
            msg.obj = params;
            msg.sendToTarget();
            return 1;
        }
        return 0;
    }

    public int callTest(Object object) {
        return 1;
    }

    @SuppressLint(value={"LongLogTag"})
    public void showMsg(String s) {
        Log.d((String)"quicksdk_unity_support fromUnity", (String)s);
    }

    public boolean isFuncSupport(int funcType) {
        return Extend.getInstance().isFunctionSupported(funcType);
    }

    public void setUnityGameObjectName(String gameObjectName) {
        this.gameObjectName = gameObjectName;
        Log.d((String)TAG, (String)("gameObjectName=" + gameObjectName));
        switch (this.initState) {
            case 1: {
                this.callUnityFunc("onInitSuccess", new JSONObject().toString());
                break;
            }
            case -1: {
                JSONObject json = new JSONObject();
                try {
                    json.put("msg", (Object)this.mInitMsg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.callUnityFunc("onInitFailed", new JSONObject().toString());
                break;
            }
        }
        this.initState = 0;
    }

    public String getChannelName() {
        return AppConfig.getInstance().getConfigValue("quicksdk_channel_name");
    }

    public void requestCallFunctionWithParamsCallBack(int funcType, String[] data) {
        Log.d((String)TAG, (String)("requestCallFunctionWithParamsCallBack: " + funcType + "\t" + data));
        Object[] objects = new Object[data.length];
        System.arraycopy(data, 0, objects, 0, data.length);
        int param0 = -111;
        try {
            param0 = Integer.valueOf(data[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("requestCallFunctionWithParamsCallBack: " + e.getMessage()));
        }
        if (param0 != -111) {
            objects[0] = param0;
        }
        this.pringData(Arrays.stream(data).toArray());
        if (Extend.getInstance().isFunctionSupported(funcType)) {
            Extend.getInstance().callFunctionWithParamsCallBack((Activity)this, funcType, new BaseCallBack(){

                public void onSuccess(Object ... objects) {
                    QuickUnityPlayerproxyActivity.this.callUnityFunc("onBaseCallbackSuccess", objects.length > 0 ? objects[0].toString() : "success");
                }

                public void onFailed(Object ... objects) {
                    QuickUnityPlayerproxyActivity.this.callUnityFunc("onBaseCallbackFaild", objects.length > 0 ? objects[0].toString() : "failded");
                }
            }, Arrays.stream(objects).toArray());
        } else {
            Log.d((String)TAG, (String)"requestCallFunctionWithParamsCallBack: The funcType is not supported");
            this.callUnityFunc("onBaseCallbackFaild", "The funcType is not supported");
        }
    }

    private void pringData(Object ... objects) {
        for (Object o : objects) {
            Log.d((String)TAG, (String)("pringData: data == " + (String)o));
        }
    }

    public String getOaid() {
        String oaid = AppConfig.getInstance().getConfigValue("channel_oaid");
        Log.d((String)TAG, (String)("oaid == " + oaid));
        return oaid;
    }

    public String getChannelVersion() {
        return AppConfig.getInstance().getChannelSdkVersion();
    }

    public int getChannelType() {
        return AppConfig.getInstance().getChannelType();
    }

    public String getSDKVersion() {
        return AppConfig.getInstance().getSdkVersion();
    }

    public String getConfigValue(String key) {
        return AppConfig.getInstance().getConfigValue(key);
    }

    public boolean isChannelHasExitDialog() {
        return QuickSDK.getInstance().isShowExitDialog();
    }

    public String getParentChannelType() {
        Log.d((String)TAG, (String)("getParentChannelType " + Extend.getInstance().getParentChannelType()));
        return Extend.getInstance().getParentChannelType() + "";
    }

    public void exitGame() {
        Log.d((String)TAG, (String)"\u8c03\u7528\u4e86exitGame()");
        this.finish();
        System.exit(0);
    }

    public void callUnityFunc(String funcName, String paramStr) {
        if (TextUtils.isEmpty((CharSequence)this.gameObjectName)) {
            Log.e((String)TAG, (String)"gameObject is null, please set gameObject first");
            return;
        }
        UnityPlayer.UnitySendMessage((String)this.gameObjectName, (String)funcName, (String)paramStr);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 101: {
                Log.e((String)TAG, (String)"login");
                User.getInstance().login((Activity)this);
                break;
            }
            case 102: {
                Log.e((String)TAG, (String)"logout");
                User.getInstance().logout((Activity)this);
                break;
            }
            case 103: {
                Log.e((String)TAG, (String)"pay");
                HashMap mapObj = (HashMap)msg.obj;
                OrderInfo orderInfo = (OrderInfo)mapObj.get("orderInfo");
                GameRoleInfo roleInfo = (GameRoleInfo)mapObj.get("roleInfo");
                Payment.getInstance().pay((Activity)this, orderInfo, roleInfo);
                break;
            }
            case 120: {
                Log.e((String)TAG, (String)"init (unityreCall)");
                this.isLancScape = this.getResources().getConfiguration().orientation == 2;
                QuickSDK.getInstance().setInitNotifier((InitNotifier)this.initNotify).setLoginNotifier((LoginNotifier)this.loginNotify).setLogoutNotifier((LogoutNotifier)this.logoutNotify).setPayNotifier((PayNotifier)this.payNotify).setExitNotifier((ExitNotifier)this.exitNotiry).setIsLandScape(this.isLancScape).setSwitchAccountNotifier((SwitchAccountNotifier)this.switchAccountNotify);
                Sdk.getInstance().init((Activity)this, this.getProductCode(), this.getProductKey());
                break;
            }
            case 104: {
                Log.e((String)TAG, (String)"exit");
                Sdk.getInstance().exit((Activity)this);
                break;
            }
            case 105: {
                Log.d((String)TAG, (String)"update role info");
                GameRoleInfo roleInfo = (GameRoleInfo)msg.obj;
                boolean isCreate = msg.arg1 == 1;
                User.getInstance().setGameRoleInfo((Activity)this, roleInfo, isCreate);
                break;
            }
            case 106: {
                int funcType = msg.arg1;
                Log.d((String)TAG, (String)("handleMessage: MSG_EXTEND_FUNC funcType == " + funcType));
                if (funcType == 112) {
                    String deviceID = this.getDeviceID();
                    this.callUnityFunc("onSuccess", deviceID);
                    break;
                }
                if (funcType == 105) {
                    Log.d((String)TAG, (String)"CallrealName:callFunctionWithParamsCallBack");
                    Extend.getInstance().callFunctionWithParamsCallBack((Activity)this, funcType, new BaseCallBack(){

                        public void onSuccess(Object ... infos) {
                            Log.d((String)QuickUnityPlayerproxyActivity.TAG, (String)("CallrealName:callFunctionWithParamsCallBack:" + infos[0].toString()));
                            JSONObject jsonObject = (JSONObject)infos[0];
                            try {
                                jsonObject.put("FunctionType", 105);
                                QuickUnityPlayerproxyActivity.this.callUnityFunc("onSuccess", jsonObject.toString() + "");
                            }
                            catch (JSONException e) {
                                Log.e((String)QuickUnityPlayerproxyActivity.TAG, (String)e.getMessage());
                            }
                        }

                        public void onFailed(Object ... infos) {
                            String msg = (String)infos[0];
                            JSONObject jsonObject = new JSONObject();
                            try {
                                jsonObject.put("FunctionType", 105);
                                jsonObject.put("msg", (Object)msg);
                                QuickUnityPlayerproxyActivity.this.callUnityFunc("onFail", jsonObject.toString());
                            }
                            catch (JSONException e) {
                                Log.e((String)QuickUnityPlayerproxyActivity.TAG, (String)e.getMessage());
                            }
                        }
                    }, new Object[0]);
                    break;
                }
                String s = Extend.getInstance().callFunction((Activity)this, funcType);
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("FunctionType", funcType);
                    jsonObject.put("msg", (Object)s);
                    this.callUnityFunc("onSuccess", jsonObject.toString());
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                }
                break;
            }
            case 901: {
                try {
                    Log.d((String)TAG, (String)"call MSG_EXTEND_FUNC_WiTH_PARAMS");
                    int funcType = msg.arg1;
                    String[] info = (String[])msg.obj;
                    Extend.getInstance().callFunctionWithParams((Activity)this, funcType, Arrays.stream(info).toArray());
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("MSG_EXTEND_FUNC_WiTH_PARAMS ERROR " + e.toString()));
                }
                break;
            }
            case 108: {
                Log.e((String)TAG, (String)"call channel share");
                ShareInfo shareInfo = (ShareInfo)msg.obj;
                Extend.getInstance().callFunctionWithParams((Activity)this, 108, new Object[]{shareInfo});
                break;
            }
            case 111: {
                Log.e((String)TAG, (String)"call getGoodsInfo");
                String gids = (String)msg.obj;
                Log.e((String)TAG, (String)("gids" + gids));
                ArrayList<String> gidsList = new ArrayList<String>();
                String[] gid = gids.split(",");
                if (gid != null) {
                    for (int i = 0; i < gid.length; ++i) {
                        gidsList.add(gid[i]);
                    }
                    Log.e((String)TAG, (String)("gidsList:" + gidsList));
                    if (gidsList.size() <= 0) break;
                    Extend.getInstance().callFunctionWithParamsCallBack((Activity)this, 111, new BaseCallBack(){

                        public void onSuccess(Object ... infos) {
                            goodsInfos = null;
                            goodsInfos = new String((String)infos[0]);
                            Log.e((String)QuickUnityPlayerproxyActivity.TAG, (String)("goods info\u524d:" + goodsInfos));
                            UnityPlayer.UnitySendMessage((String)QuickUnityPlayerproxyActivity.this.gameObjectName, (String)"onSuccess", (String)goodsInfos);
                        }

                        public void onFailed(Object ... infos) {
                            String msg = (String)infos[0];
                            QuickUnityPlayerproxyActivity.this.callUnityFunc("onFail", msg + "");
                        }
                    }, new Object[]{gidsList});
                    break;
                }
                this.callUnityFunc("onFail", gids);
                break;
            }
        }
        return false;
    }

    public abstract String getProductCode();

    public abstract String getProductKey();

    private class QuickUnityExitNotiry
    implements ExitNotifier {
        private QuickUnityExitNotiry() {
        }

        public void onSuccess() {
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onExitSuccess", "success");
        }

        public void onFailed(String msg, String trace) {
        }
    }

    private class QuickUnityPayNotify
    implements PayNotifier {
        private QuickUnityPayNotify() {
        }

        public void onSuccess(String quickOrderId, String cpOrderId, String extrasParams) {
            JSONObject json = new JSONObject();
            try {
                json.put("orderId", (Object)quickOrderId);
                json.put("cpOrderId", (Object)cpOrderId);
                json.put("extraParam", (Object)extrasParams);
            }
            catch (Exception exception) {
                // empty catch block
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onPaySuccess", json.toString());
        }

        public void onCancel(String cpOrderID) {
            JSONObject json = new JSONObject();
            try {
                json.put("orderId", (Object)"");
                json.put("cpOrderId", (Object)cpOrderID);
                json.put("extraParam", (Object)"");
            }
            catch (Exception exception) {
                // empty catch block
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onPayCancel", json.toString());
        }

        public void onFailed(String cpOrderID, String message, String trace) {
            JSONObject json = new JSONObject();
            try {
                json.put("orderId", (Object)"");
                json.put("cpOrderId", (Object)cpOrderID);
                json.put("extraParam", (Object)message);
            }
            catch (Exception exception) {
                // empty catch block
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onPayFailed", json.toString());
        }
    }

    private class QuickUnityLogoutNotify
    implements LogoutNotifier {
        private QuickUnityLogoutNotify() {
        }

        public void onSuccess() {
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onLogoutSuccess", "success");
        }

        public void onFailed(String msg, String trace) {
        }
    }

    private class QuickUnitySwitchAccountNotify
    implements SwitchAccountNotifier {
        private QuickUnitySwitchAccountNotify() {
        }

        public void onCancel() {
        }

        public void onFailed(String msg, String trace) {
        }

        public void onSuccess(UserInfo userInfo) {
            Log.d((String)QuickUnityPlayerproxyActivity.TAG, (String)"\u5207\u6362\u8d26\u53f7\u6210\u529f");
            JSONObject json = new JSONObject();
            try {
                json.put("userName", (Object)(userInfo.getUserName() == null ? "" : userInfo.getUserName()));
                json.put("userId", (Object)(userInfo.getUID() == null ? "" : userInfo.getUID()));
                json.put("userToken", (Object)(userInfo.getToken() == null ? "" : userInfo.getToken()));
                json.put("channelToken", (Object)userInfo.getChannelToken());
                json.put("msg", (Object)"success");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onSwitchAccountSuccess", json.toString());
        }
    }

    private class QuickUnityLoginNotify
    implements LoginNotifier {
        private QuickUnityLoginNotify() {
        }

        public void onSuccess(UserInfo userInfo) {
            JSONObject json = new JSONObject();
            try {
                json.put("userName", (Object)(userInfo.getUserName() == null ? "" : userInfo.getUserName()));
                json.put("userId", (Object)(userInfo.getUID() == null ? "" : userInfo.getUID()));
                json.put("userToken", (Object)(userInfo.getToken() == null ? "" : userInfo.getToken()));
                json.put("channelToken", (Object)userInfo.getChannelToken());
                json.put("msg", (Object)"success");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onLoginSuccess", json.toString());
        }

        public void onCancel() {
            JSONObject json = new JSONObject();
            try {
                json.put("msg", (Object)"cancel");
            }
            catch (Exception exception) {
                // empty catch block
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onLoginFailed", json.toString());
        }

        public void onFailed(String msg, String trace) {
            JSONObject json = new JSONObject();
            try {
                json.put("msg", (Object)msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            QuickUnityPlayerproxyActivity.this.callUnityFunc("onLoginFailed", json.toString());
        }
    }

    private class QuickUnityInitNotify
    implements InitNotifier {
        private QuickUnityInitNotify() {
        }

        public void onSuccess() {
            if (!TextUtils.isEmpty((CharSequence)QuickUnityPlayerproxyActivity.this.gameObjectName)) {
                QuickUnityPlayerproxyActivity.this.callUnityFunc("onInitSuccess", new JSONObject().toString());
            } else {
                QuickUnityPlayerproxyActivity.this.initState = 1;
            }
        }

        public void onFailed(String msg, String trace) {
            if (!TextUtils.isEmpty((CharSequence)QuickUnityPlayerproxyActivity.this.gameObjectName)) {
                JSONObject json = new JSONObject();
                try {
                    json.put("msg", (Object)msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                QuickUnityPlayerproxyActivity.this.callUnityFunc("onInitFailed", new JSONObject().toString());
            } else {
                QuickUnityPlayerproxyActivity.this.mInitMsg = msg;
                QuickUnityPlayerproxyActivity.this.initState = -1;
            }
        }
    }
}

